#import "UKShadowCopyAppDelegate.h"
#import "NDAlias+AliasFile.h"

@implementation UKShadowCopyAppDelegate

-(void)	awakeFromNib
{
	NSWorkspace*			ws = [NSWorkspace sharedWorkspace];
	NSNotificationCenter*	cent = [ws notificationCenter];
	
	[cent addObserver: self selector:@selector(volumeMounted:) name: NSWorkspaceDidMountNotification object: cent];
	[cent addObserver: self selector:@selector(volumeMounted:) name: NSWorkspaceDidMountNotification object: ws];
	
	statusItem = [[[NSStatusBar systemStatusBar] statusItemWithLength: 30] retain];
	[statusItem setTarget: self];
	[statusItem setImage: [NSImage imageNamed: @"SCOnBarIcon"]];
	
	[self turnOffStatusItem];
}

-(void)	dealloc
{
	NSNotificationCenter*	cent = [[NSWorkspace sharedWorkspace] notificationCenter];
	[cent removeObserver: self];
	
	[statusItem release];
	
	[super dealloc];
}


-(void)	volumeMounted: (NSNotification*)notif
{
	[self application: NSApp openFile: [[notif userInfo] objectForKey: @"NSDevicePath"]];
}


-(void)	setStatus: (NSString*)str
{
	NSDictionary*		attrs = [NSDictionary dictionaryWithObjectsAndKeys: [NSFont menuBarFontOfSize: 14], NSFontAttributeName, nil];
	[statusItem setTitle: str];
	[statusItem setLength: 30 +[str sizeWithAttributes: attrs].width];
}


-(void)	turnOffStatusItem	// Delayed so user sees it even on fast Macs or with few files on a disk:
{
	[NSTimer scheduledTimerWithTimeInterval: 3.0 target: self selector: @selector(actuallyTurnOffStatusItem:)
			userInfo: nil repeats: NO];
}

-(void)	actuallyTurnOffStatusItem: (NSTimer*)timer
{
	[statusItem setEnabled: NO];
	[statusItem setLength: 0];
}


-(BOOL)	application: (NSApplication*)sender openFile: (NSString*)filename
{
	[statusItem setEnabled: YES];
	[self setStatus: @"0/0"];

	NSString*	rootFolder = [@"~/DiskIndex/" stringByExpandingTildeInPath];
	
	[[NSFileManager defaultManager] createDirectoryAtPath: rootFolder attributes: [NSDictionary dictionary]];
	
	NSString*		newFolder = [rootFolder stringByAppendingPathComponent: [filename lastPathComponent]];
	
	if( [[NSFileManager defaultManager] fileExistsAtPath: newFolder] )
	{
		[self turnOffStatusItem];
		return YES;		// Already indexed.
	}
		
	[filesToCopy release];
	filesToCopy = [[NSMutableArray alloc] init];
	[filesToCopyTo release];
	filesToCopyTo = [[NSMutableArray alloc] init];
	
	NSAutoreleasePool*	pool = [[NSAutoreleasePool alloc] init];
	[self listOneFolder: filename toFolder: newFolder];
	[pool release];
	
	// Now process list:
	NSEnumerator*	srcEnny = [filesToCopy objectEnumerator];
	NSEnumerator*	dstEnny = [filesToCopyTo objectEnumerator];
	NSString*		srcPath = nil;
	NSString*		dstPath = nil;
	int				x = 0, count = [filesToCopy count];
	
	while( (srcPath = [srcEnny nextObject]) && (dstPath = [dstEnny nextObject]) )
	{
		x++;
		
		BOOL		isDir = NO;
		[[NSFileManager defaultManager] fileExistsAtPath: srcPath isDirectory: &isDir];
		if( isDir && ![[NSWorkspace sharedWorkspace] isFilePackageAtPath: srcPath] )
			[[NSFileManager defaultManager] createDirectoryAtPath: dstPath attributes: [NSDictionary dictionary]];
		else
		{
			NDAlias*	ali = [[NDAlias alloc] initWithPath: srcPath];
			[ali writeToFile: dstPath];
			[ali release];
		}
		
		if( (x & 0x0F) == 0x0F )
		{
			[self setStatus: [NSString stringWithFormat: @"%d/%d", x, count]];
			
			NSEvent* evt = [NSApp nextEventMatchingMask: NSAnyEventMask untilDate: [NSDate distantPast] inMode: NSModalPanelRunLoopMode dequeue: YES];	
			if( evt )
				[NSApp sendEvent: evt];
		}
	}
	
	[self setStatus: [NSString stringWithFormat: @"%d/%d", count, count]];
	[filesToCopy release];
	filesToCopy = nil;
	[filesToCopyTo release];
	filesToCopyTo = nil;
	
	[self turnOffStatusItem];
	
	return YES;
}

-(void)	listOneFolder: (NSString*)selectedFolder toFolder: (NSString*)destFolder
{
	[filesToCopy addObject: selectedFolder];
	[filesToCopyTo addObject: destFolder];
	
	NSDirectoryEnumerator*	enny = [[NSFileManager defaultManager] enumeratorAtPath: selectedFolder];
	NSString*				currName = nil;
	int						x = 0;
	
	while( (currName = [enny nextObject]) )
	{
		[enny skipDescendents];
		x++;
		
		if( [currName characterAtIndex: 0] == '.' )
			continue;
		
		NSString*		srcPath = [selectedFolder stringByAppendingPathComponent: currName];
		NSString*		dstPath = [destFolder stringByAppendingPathComponent: currName];
		
		[filesToCopy addObject: srcPath];
		[filesToCopyTo addObject: dstPath];
		
		if( (x & 0x0F) == 0x0F )
		{
			[self setStatus: [NSString stringWithFormat: @"0/%d", [filesToCopy count]]];
			
			NSEvent* evt = [NSApp nextEventMatchingMask: NSAnyEventMask untilDate: [NSDate distantPast] inMode: NSModalPanelRunLoopMode dequeue: YES];	
			if( evt )
				[NSApp sendEvent: evt];
		}
		
		if( [[enny fileAttributes] fileType] == NSFileTypeDirectory )
		{
			if( ![[NSWorkspace sharedWorkspace] isFilePackageAtPath: srcPath] )
			{
				NSAutoreleasePool*	pool = [[NSAutoreleasePool alloc] init];
				[self listOneFolder: srcPath toFolder: dstPath];
				[pool release];
			}
		}
	}
}

@end
